/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.compat.eiv.display;

import com.zurrtum.create.compat.eiv.CreateDisplay;
import com.zurrtum.create.compat.eiv.EivCommonPlugin;
import com.zurrtum.create.content.kinetics.mixer.CompactingRecipe;
import com.zurrtum.create.content.processing.recipe.HeatCondition;
import com.zurrtum.create.content.processing.recipe.ProcessingOutput;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.foundation.fluid.FluidIngredient;
import de.crafty.eiv.common.api.recipe.EivRecipeType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_6903;
import net.minecraft.class_8786;

public class CompactingDisplay
extends CreateDisplay {
    public List<class_1799> results;
    public List<Float> chances;
    public List<List<class_1799>> ingredients;
    public List<FluidIngredient> fluidIngredients;
    public HeatCondition heat;

    public CompactingDisplay() {
    }

    public CompactingDisplay(class_8786<CompactingRecipe> entry) {
        CompactingRecipe recipe = (CompactingRecipe)entry.comp_1933();
        List<ProcessingOutput> outputs = recipe.results();
        int size = outputs.size();
        this.results = new ArrayList<class_1799>(size);
        this.chances = new ArrayList<Float>(size);
        for (ProcessingOutput output : outputs) {
            this.results.add(output.create());
            this.chances.add(Float.valueOf(output.chance()));
        }
        this.ingredients = new ArrayList<List<class_1799>>(recipe.ingredients().size());
        CompactingDisplay.addSizedIngredient(recipe.ingredients(), this.ingredients);
        this.fluidIngredients = recipe.fluidIngredients();
        this.heat = recipe.heat();
    }

    public void writeToTag(class_2487 tag) {
        class_6903<class_2520> ops = CompactingDisplay.getServerOps();
        tag.method_67493("results", STACKS_CODEC, ops, this.results);
        tag.method_67493("chances", CreateCodecs.FLOAT_LIST_CODEC, ops, this.chances);
        tag.method_67493("ingredients", STACKS_LIST_CODEC, ops, this.ingredients);
        if (!this.fluidIngredients.isEmpty()) {
            tag.method_67493("fluidIngredients", FLUID_INGREDIENTS_CODEC, ops, this.fluidIngredients);
        }
        if (this.heat != HeatCondition.NONE) {
            tag.method_67493("heat", HeatCondition.CODEC, ops, (Object)this.heat);
        }
    }

    public void loadFromTag(class_2487 tag) {
        class_6903<class_2520> ops = CompactingDisplay.getClientOps();
        this.results = (List)tag.method_67492("results", STACKS_CODEC, ops).orElseThrow();
        this.chances = (List)tag.method_67492("chances", CreateCodecs.FLOAT_LIST_CODEC, ops).orElseThrow();
        this.ingredients = (List)tag.method_67492("ingredients", STACKS_LIST_CODEC, ops).orElseThrow();
        this.fluidIngredients = tag.method_67492("fluidIngredients", FLUID_INGREDIENTS_CODEC, ops).orElse(List.of());
        this.heat = tag.method_67492("heat", HeatCondition.CODEC, ops).orElse(HeatCondition.NONE);
    }

    public EivRecipeType<CompactingDisplay> getRecipeType() {
        return EivCommonPlugin.PACKING;
    }
}

